*!! BLIND
*!! Output Datawise Survey
*!! Written by Brian Fitzpatrick (bfitzpatrick@gibsonconsult.com)

clear all
preamble, f(BLIND/08_school_climate_survey/2025)  log(02_survey_output)
if `"`c(username)'"' == `"BrianFitzpatrick"' global sp ""
else ERROR - ENTER SP DIRECTORY 

set scheme cleanplots
global test 0 //if test=1, loop over only one school
global ts `"Fake High School"' //test school

global hq 1 //high-quality figures (this takes way longer!!!)

*sections = 1s run a section, 0s don't
global build 1
global figures 1
global reports 1

*define key macros
global at_least 10 //drop cells if below this number

*define question blocks - this could be by group or by topic
global qs1 q27 q41 q55 //safety
global qs2 q11_1 q11_2 q11_3 //identity affirmation
global qs3 q21 q32 q56 //belonging
global qsa $qs1 $qs2 $qs3

*shorten/generalize these
global xt1 `""How often do you worry about safety at your school?""'
global xt2 `""How well does your school affirm your identity?""'
global xt3 Respondent's sense of belonging at their school.

*global qs2 q19 q36 q54 //respect
*global qs3 q14 q28  //engagement

*define groups
global g1 Students 
global g2 Staff 
global g3 Parents

*define colors 
global lo_color $giblue
global mid_color gs8
global hi_color dkorange

*difference from school average that gets treated as "similar" (this amount is plus or minus)
global sim 2.49999

	
/*
use `"${final}/school_climate_survey"', clear
fre $qs1 
fre $qs2 
fre $qs3
*/

************************Build a Dataset for Each Figure*************************
************************Build a Dataset for Each Figure*************************
************************Build a Dataset for Each Figure*************************
if $build == 1 {
	
	***build the comparison "datasets"
	local c 1
	use `"${final}/school_climate_survey"', clear
	foreach q in $qsa { //dummies for each response option
		qui tab `q', gen(`q'_)
		levelsof `q'
		foreach l in `r(levels)' {
			global lab`l' `:lab (`q') `l''
			global last `l'
		}
		
		levelsof school_level
		foreach l in `r(levels)' {
			preserve 
			if `l'==4 replace school_level=4 if !mi(school_level) //we will compare "other" schools to the overall averages
			keep if school_level==`l' //otherwise, compare elementary schools to all other elementary schools, ect.
			global question `:char `q'[stem]'
			collapse (sum) `q'_? , by(school_level) 
			gen q="`q'"
			char q[`q'] $question
			rename `q'_? a?
			forval i=1 / $last { //label dummies
				la var a`i' `"${lab`i'}"'
			}
			*if strpos(`"${lab1}"', "Extremely") !=0 { 
			if `c'>6 { //switch these out for more generic labels - we need them to match
				dis "Adjusted the Labels"
				la var a1 "Very high"
				la var a2 "High"
				la var a3 "Medium"
				la var a4 "Low"
				la var a5 "Very Low"
			}
			local labs
			forval i=1 / $last {
				local labs `labs' `:var lab a`i'' - //extra dash? - don't worry about it
			}
			gen labels="`labs'"
			gen comp=1
			save `"${processed}/temp/comp_sl`l'_`q'"', replace
			restore
		}
		local ++c
	}
	
	***build the unique school dataset 
	levelsof school2
	if $test == 1 local list ${ts}
	else local list `r(levels)'
	foreach s in `"`list'"' {
		local s_np=subinstr(`"`s'"', ".", "", .)
		foreach q in $qsa {
			preserve 
			keep if school2=="`s'"
			qui sum school_level 
			assert `r(min)'==`r(max)' //schools should only have 1 school level - just using this as the by stat to save it
			global sl `r(max)'
			collapse (sum) `q'_? , by(school_level) 
			gen q="`q'"
			rename `q'_? a?

			gen comp=0
			save `"${processed}/temp/comp_`q'_`s_np'"', replace
			restore
		}	

		***compile one dataset for each figure (for each school)
		forval fig = 1/3 {
			preserve
			local c 1 //c is for counter
			dis `"foreach v in ${qs`fig'}"'
			foreach q in ${qs`fig'} {
				*!BF Note 3/19/2025: the patern here is load the first comparison dataset, then append the first school dataset, then append the second comparison dataset, then append the second school dataset, ect...
				if `c'==1 {
					use `"${processed}/temp/comp_sl${sl}_`q'"', clear
					gen group=""
				}
				else append using `"${processed}/temp/comp_sl${sl}_`q'"'
				append using `"${processed}/temp/comp_`q'_`s_np'"'
				dis `"${g`c'}"'
				replace group=`"${g`c'}"' if mi(group)
				local ++c
				dis `"`s'"'
				*list
				qui distinct labels 
				*assert `r(ndistinct)'==1 //no longer using this
			}	
			*create proportions out of Ns
			egen rs_a=rowtotal(a*)
			la var rs_a "Number of Respondents"
			foreach v of varlist a* {
				local n=substr("`v'", 2, .)
				gen p`n'=(`v'/rs_a)*100
			}
			save `"${processed}/figures/comp_fig`fig'_`s_np'"', replace
			restore
		}
	}
}

**********************End Build a Dataset for Each Figure***********************
**********************End Build a Dataset for Each Figure***********************
**********************End Build a Dataset for Each Figure***********************


*******************************Create the Figures*******************************
*******************************Create the Figures*******************************
*******************************Create the Figures*******************************
if $figures == 1 {
	use `"${final}/school_climate_survey"', clear
	
	*define x titles - must do manually
	foreach v in $qsa {
		dis `"`v'_lab `"`:char `v'[stem]'"' "'
	}
	
	*global xt3 xlab(1.5 `""Students: How interesting do you find the" "things you learn in your classes?""' 4.5 `""Staff: On most days, how enthusiastic are the" "students about being at school?""' , labsize(2.5) labgap(2.5))

	levelsof school2
	if $test == 1 local list ${ts}
	else local list `r(levels)'
	foreach s in `"`list'"' {
		local s_np=subinstr(`"`s'"', ".", "", .)
		forval fig = 1/3 {
			
			use `"${processed}/figures/comp_fig`fig'_`s_np'"', clear
			
			*identify when there are too few responses
			bys q: egen samp=min(rs_a)
			*drop if samp < $at_least 
			*!BF Note 4/3/2025: if the above line of code is here, the bars will stretch

			gen j=_n
			gen p=_n
			forval i = 3(2)18 { //overkill
				replace p=p+1 if j>=`i' //adding the gaps
			}
			drop j
			 
			*set up colors - do later, if ever
			
			*x labels
			local i 1
			local g 1
			local xl 	
			local xl2
			levelsof p
			foreach x in `r(levels)'  { //2 x labels
				if comp[`i']==1 local xl `xl' `x' `"BLIND"'
				if comp[`i']==0 {
					local xl `xl' `x' `"Your School"'
					local question=q[`i'] 
					local xl2 `xl2' `=`x'-.5' `"${g`g'}"' 
					local ++g
				}
				local ++i
			}
			dis `"`xl'"'
			dis `"`xl2'"'
			
			drop if samp < $at_least 
			*!BF Note 4/3/2025: if the above line of code is here, the bars will not stretch

			*legend 
			local leg 
			forval a=1/5 {
				local leg `leg' `=`a'*2-1' "`:var lab a`a''"
			}
			dis `"`leg'"'
			
			*prep note
			local note
			if `=school_level[1]'==4 local note `"Respondents from `s' in each group are compared to respondents in K-12 across BLIND."'
			else local note `"This graph compares respondents from `s' to respondents in all `=lower(`"`:lab (school_level) `=school_level[1]''"')' schools across BLIND."'
			
			*set up bar positions
			gen bar1=100
			local tb 
			local i 1
			foreach color in "${lo_color}" "${teal}" "${mid_color}" "${gold}" "${hi_color}" { //graph colors
				local tb `tb' (bar bar`i' p , bcolor(`"`color'"') ) //place the bar
				gen bar`=`i'+1'=bar`i'-p`i' //size of the next bar
				gen mlp`i'=bar`=`i'+1'+((bar`i'-bar`=`i'+1')/2) //location of the label
				gen ml`i'=round(p`i', 1) //make the label...
				tostring ml`i', replace 
				replace ml`i'=ml`i'+"%"
				replace ml`i'="" if p`i'<1 //unless the bar is too small
				*last, place the label
				local tb `tb' (scatter mlp`i' p , msymbol(none) mlabel(ml`i') mlabposition(0) mlabcolor(white) mlabsize(2.5))
				local ++i
			}
			assert bar6<.5 & bar6>-.5 //the 5 bars should sum to 100 - can't be 0 due to rounding errors
			
			if $hq == 1 local w width(4000) 
			else local w 
			qui count
			if `r(N)'>1 twoway `tb' , xlab(none) xtitle("") ///
			legend(order(`leg') pos(3) col(1)) ///
			xmlab( `xl' , labsize(2.25)) ///
			xlab(`xl2' , labsize(3) labgap(3)) ///
			ylab(0(20)100 0 "0%" 20 "20%" 40 "40%" 60 "60%" 80 "80%" 100 "100%") ///
			ytitle("Percent of Respondents", size(3)) ///
			note(`"Note: `note'"' `"Due to roundoff errors, bar labels do not always add up to 100."', span size(2.25)) ///
			saving(`"${processed}/figures/comp_fig`fig'_`s_np'"', replace) 
						
			graph export `"${processed}/figures/comp_fig`fig'_`s_np'.png"', replace `w'  
		}
	}
}
*****************************End Create the Figures*****************************
*****************************End Create the Figures*****************************
*****************************End Create the Figures*****************************

*******************************Create the Reports*******************************
*******************************Create the Reports*******************************
*******************************Create the Reports*******************************
if $reports == 1 {
	
	*high/low/mid counters 
	local hi 0
	local lo 0
	local mi 0
	
	use `"${final}/school_climate_survey"', clear
	
	if $test == 1 levelsof school_level if school2==`"${ts}"'
	else levelsof school_level
	foreach l in `r(levels)' {
		
		preserve 
		local lev `:lab (school_level) `l''
		
		*for later (this cannot be after the replace command for group 4)
		levelsof school2 if school_level==`l'
		if $test == 1 local list ${ts}
		else local list `r(levels)'
		
		if `l'==4 replace school_level=4 if !mi(school_level) //we will compare "other" schools to the overall averages
		keep if school_level==`l'
		
		*calculate district averages
		local i=1
		foreach v in $qsa {
			fre `v'
			qui count if !mi(`v')
			local deno `r(N)'
			*!BF Note 3/21/2025: focus on the negative responses to the safety question, and the positive reactions to the others
			*!BF Note 4/2/2025: I made this next part more complicated than it needs to be to "fix" rounding errors
			if `i'<=3 count if (`v'==4) 
			else count if (`v'==1) 
			local temp1=`=round(`=(`r(N)'/`deno')*100', 1)'
			if `i'<=3 count if (`v'==5) 
			else count if (`v'==2) 
			local temp2=`=round(`=(`r(N)'/`deno')*100', 1)'
			dis `"dist`i'=`temp1'+`temp2'"'
			local dist`i'=`temp1'+`temp2'
			dis `"`dist`i''"'
			local ++i
		}

		foreach s in `"`list'"' {
		local s_np=subinstr(`"`s'"', ".", "", .)
			
			*save response numbers 
			forval i=1/3 {
				qui count if role==`i' & school2==`"`s'"'
				local resp`i'=`r(N)'
			}
		
			*calculate difference between school and district averages
			local i=1
			foreach v in $qsa {
				fre `v' if school2==`"`s'"'
				count if !mi(`v') & school2==`"`s'"'
				local deno`i' `r(N)' //use this to blind descriptions
				
				*!BF Note 4/2/2025: I made this next part more complicated than it needs to be to "fix" rounding errors
				if `i'<=3 count if (`v'==4) & school2==`"`s'"'
				else count if (`v'==1) & school2==`"`s'"'
				local temp1=`=round(`=(`r(N)'/`deno`i'')*100', 1)'
				if `i'<=3 count if (`v'==5) & school2==`"`s'"'
				else count if (`v'==2) & school2==`"`s'"'
				local temp2=`=round(`=(`r(N)'/`deno`i'')*100', 1)'
				dis `"local sch`i'=`temp1'+`temp2'"'
				local sch`i'=`temp1'+`temp2'
				
				local diff`i'=`sch`i''-`dist`i''
				if `diff`i'' > $sim {
					local cat`i'=1
					local ++hi 
				}
				else if `diff`i'' < -$sim {
					local cat`i'=-1
					local ++lo
				}
				else {
					local cat`i' 0
					local ++mi
				}
				dis `"Cat `i' = `cat`i''"'
				dis `"Difference: `sch`i''-`dist`i''=`diff`i''"'
				local diff`i'=int(abs(`diff`i'')) //we don't want those negative signs in the text
				
				local ++i
			}
		
			putpdf clear 
			putpdf begin, font(Arial, 10)
			
			*define default paragraph spacing 
			local none spacing(before, 0) spacing(after, 0) spacing(line, 0)
			local sm spacing(before, .1) spacing(after, 0) spacing(line, 0)
			local big spacing(before, .25) spacing(after, 0) spacing(line, 0)
			
			*title
			putpdf paragraph, halign(center) `sm'
			putpdf text (`"`s'"'), bold font(Arial, 12)
			putpdf paragraph, halign(center) `sm'
			putpdf text (`"Results of the 2024-25 School Climate Survey"')
			putpdf paragraph, halign(center) `sm'
			putpdf text (`"Gibson Consulting Group"')
			
			*intro 
			if `l'==4 local comp responses from all of BLIND
			else local comp all BLIND `=lower("`:lab (school_level) `l''")' schools
			putpdf paragraph, `big'
			putpdf text (`"This document summarizes responses to key questions for the BLIND School Climate Survey of students, school staff, and parents/guardians in the winter of 2024-25. At `s', `resp1' students, `resp2' staff, and `resp3' parents/guardians responded to the survey. This document summarizes their responses to key questions and compares their responses to `comp'. If fewer than 10 people responded to any of these questions, their answers are not shown to preserve anonymity."')
			
			*define components of the rest of the text
			if `l'==4 local comp from across all BLIND schools
			else local comp across BLIND `=lower("`:lab (school_level) `l''")' schools
			
			local sh1 School Safety 
			local sh2 Identity Affirmation 
			local sh3 Sense of Belonging
			
			*define what to put in when blinding
			local blind1 `"     ▪ Fewer than 10 students answered this question."'
			local blind2 `"     ▪ Fewer than 10 staff answered this question."'
			local blind3 `"     ▪ Fewer than 10 parents/guardians answered this question."'
			
			*Put text into PDF
			local sub 0 //sub-heading counter
			forval b=1/9 { //b is for bullet, kind of
				if `b'==1 | `b'==4 | `b'==7 {
					local ssp 1 //group counter , 1=student, 2=staff, 3=parent
					local ++sub
					if `b'==4 | `b'==7 {
						putpdf pagebreak
						putpdf paragraph
					}
					*subheader
					putpdf paragraph, `big' halign(center)
					putpdf text ("`sh`sub''"), bold 
					*survey question summary
					putpdf paragraph, `sm' 
					putpdf text (`"${xt`sub'}"'), bold				
					*graph
					putpdf paragraph, halign(center) `none'
					putpdf image `"${processed}/figures/comp_fig`sub'_`s_np'.png"', width(8) 
					*qualifying statement
					putpdf paragraph, `sm'
					putpdf text ("Compared to respondents `comp':") 
				}
				else local ++ssp

				*define directional phrases
				if `cat`b''==-1 local dir `diff`b''% less
				if `cat`b''==0 local dir about as
				if `cat`b''==1 local dir `diff`b''% more
				
				dis `"`dir'"'
				
				local t1_1 Students at `s' were 
				local t1_2 likely to say they "usually" or "always" worry about safety.
				
				local t2_1 Staff were 
				local t2_2 likely to say they "usually" or "always" worry about safety.
				
				local t3_1 Parents/guardians at `s' were 
				local t3_2 likely to say they "usually" or "always" worry about their child's school.
				
				local t4_1 Students at `s' were 
				local t4_2 likely to say "a great deal" or "a lot" when asked if their school affirms their identity.
				
				local t5_1 Staff were 
				local t5_2 likely to say "a great deal" or "a lot" when asked if their school affirms their identity.
				
				local t6_1 Parents/guardians with a child attending `s' were 
				local t6_2 likely to say "a great deal" or "a lot" when asked if their school affirms their identity.
				
				local t7_1 Students were 
				local t7_2 likely to say they "completely belong" or "belong quite a bit" at `s'.
				
				local t8_1 Staff were 
				local t8_2 likely to say that relationships between staff and students at `s' are "extremely respectful" or "quite respectful."
				
				local t9_1 Parents/guardians at `s' were 
				local t9_2 likely to say they "strongly agree" or "agree" when asked if they feel a sense of belonging in their child's school community.
				
				putpdf paragraph, `sm'
				if `deno`b'' < $at_least putpdf text (`"`blind`ssp''"') 
				else {
					putpdf text (`"     ▪ `t`b'_1'"')
					putpdf text (`" `dir'"'), bold
					putpdf text (`" `t`b'_2'"')
				}
				
			}
			putpdf save `"${output}/anon/School Climate Summary - `s_np'.pdf"', replace
		}
		restore 
	}
	
	dis `"Low Ratings: `lo'"'
	dis `"High Ratings: `hi'"'
	dis `"Similar Ratings: `mi'"'
	dis `"Percent Similar: `=int(`=(`mi'/(`lo'+`mi'+`hi'))*100')'%"'
}
*****************************End Create the Reports*****************************
*****************************End Create the Reports*****************************
*****************************End Create the Reports*****************************

log close
stop 





*Horizontal version of the figures
		*set up bar positions
		gen bar1=100
		local tb 
		local i 1
		foreach color in "${hi_color}" "${gold}" "${mid_color}" "${lo_color}%66" "${lo_color}" { 
			local tb `tb' (bar bar`i' p , bcolor(`"`color'"') horizontal) //mlab(part) mlabcolor(black) mlabformat(%3.0f)
			gen bar`=`i'+1'=bar`i'-p`i'
			gen mlp`i'=bar`=`i'+1'+((bar`i'-bar`=`i'+1')/2)
			gen ml`i'=round(p`i', 1)
			tostring ml`i', replace 
			replace ml`i'=ml`i'+"%"
			replace ml`i'="" if p`i'<1 
			local tb `tb' (scatter p mlp`i' , msymbol(none) mlabel(ml`i') mlabposition(0) mlabcolor(white) mlabsize(2.5) )
			local ++i
		}
		*x labels
		local i 1
		local xl 	
		local xl2
		levelsof p
		foreach x in `r(levels)' {
			if comp[`i']==1 local xl `xl' `x' `"BLIND"'
			if comp[`i']==0 {
				local xl `xl' `x' `"Your School"'
				local question=q[`i'] 
				local xl2 `xl2' `=`x'-.5' "`:char q[`question']'"
			}
			local ++i
		}
		dis `"`xl'"'
		dis `"`xl2'"'
		*legend 
		local leg 
		forval a=1/5 {
			local leg `leg' `=`a'*2-1' "`:var lab a`a''"
		}
		dis `"`leg'"'
		
		dis `"`tb'"'
		twoway `tb' ,  ///
		legend(order(`leg') pos(6) row(1)) ///
		ytitle("") ymlab( `xl' ) ylab(`xl2', labsize(1.5)) ///
		saving(`"${output}/ap_stacked_`c'_alt"', replace) ///
		xlab(0(20)100 0 "0%" 20 "20%" 40 "40%" 60 "60%" 80 "80%" 100 "100%") ///
		xtitle("Percent of Respondents") 



log close
stop

